# Solving the Josephus Problem Using an Array-Based Queue

## 1. Introduction to Queues

A **queue** is a linear data structure that follows the **FIFO (First-In, First-Out)** principle — elements are inserted at the **rear** and removed from the **front**.
Typical queue operations include:

* **enqueue(x):** adds an element at the rear
* **dequeue():** removes the element at the front
* **front():** views the element at the front without removing it
* **isEmpty():** checks if the queue is empty

When implemented using arrays, these operations can be made to run in **O(1)** time using modular arithmetic to handle circular indexing.

---

## 2. The Josephus Problem

The **Josephus problem** is a classic theoretical problem involving *n* people standing in a circle, eliminating every *k*-th person until only one remains.
The task is to determine the position of the survivor.

Using a **queue** is both intuitive and efficient:

1. Enqueue all people numbered from `1` to `n`.
2. Dequeue and re-enqueue the person at the front of the queue k times.
3. Dequeue the `k`-th person (eliminated).
4. Continue until only one person remains — the survivor.

This algorithm runs in **O(n × k)** time, as each elimination requires *k* dequeue/enqueue operations.

---

## 3. Queue Implementation Files

This project implements a **custom queue** from scratch, without relying on Java’s collection classes.

* **`Queue.java`**
  Defines the **Queue ADT** specifying the standard queue operations (`enqueue`, `dequeue`, `front`, `isEmpty`, and `size`).

* **`QueueException.java`**
  Declares a **custom exception class** thrown when attempting invalid operations (e.g., dequeuing from an empty queue).

* **`ArrayBasedQueue.java`**
  Implements the `Queue` interface using an **array-based circular structure**.
  The class maintains `front` and `rear` indices, wrapping around the array to ensure **O(1)** enqueue and dequeue operations.

* **`ArrayBasedQueueDemo.java`**
  Demonstrates basic queue functionality through simple enqueue and dequeue tests.

---

## 4. Josephus Problem Implementation

The algorithm that leverages the queue to solve the **Josephus problem** is found in **`Main.java`**.

**Algorithm Summary:**

1. Initialize a queue with all people from `1` to `n`.
2. While more than one person remains:

   * Repeat `k` times: dequeue the front person and enqueue them back.
   * Dequeue the next person (they are eliminated).
3. The last person remaining in the queue is the **winner**.

**Complexity:**

* **Time Complexity:** O(n × k)
* **Space Complexity:** O(n)
